#ifndef _TOF_B_I2C_H_
#define _TOF_B_I2C_H_

#include <wiringPi.h>
#include <wiringPiI2C.h>
#include <stdint.h>
#include <stdlib.h> //itoa()
#include <stdio.h>
#include <unistd.h>

#define ADDR_SLAVE 0x08//7-bit slave address=ID+0x08 ID=0
#define ADDR_SLAVE1 0x09//7-bit slave address=ID+0x08 ID=1

//#define ADDR_WRITE_SLAVE (uint8_t)((ADDR_SLAVE<<1)|0x00)//8-bit slave write address
//#define ADDR_READ_SLAVE (uint8_t)((ADDR_SLAVE<<1)|0x01)//8-bit slave read address

//Register variable size address list (commonly used)
//#define TOF_REGISTER_SIZE 4//single register length
#define TOF_REGISTER_TOTAL_SIZE 48//Total length of all registers

#define TOF_ADDR_MODE 0x0c//pattern variable address
#define TOF_SIZE_MODE 1//The number of bytes occupied by the pattern variable

#define TOF_ADDR_ID 0x0d//ID variable address
#define TOF_SIZE_ID 1//The number of bytes occupied by the ID variable

#define TOF_ADDR_UART_BAUDRATE 0x10//UART baud rate variable address
#define TOF_SIZE_UART_BAUDRATE 4//The number of bytes occupied by the UART baud rate variable

#define TOF_ADDR_SYSTEM_TIME 0x20//System time variable address
#define TOF_SIZE_SYSTEM_TIME 4//The number of bytes occupied by the system time variable

#define TOF_ADDR_DIS 0x24//distance variable address
#define TOF_SIZE_DIS 4//The number of bytes occupied by the distance variable

#define TOF_ADDR_DIS_STATUS 0x28//Distance status indication variable address
#define TOF_SIZE_DIS_STATUS 2//The number of bytes occupied by the distance status indicator variable

#define TOF_ADDR_SIGNAL_STRENGTH 0x2a//Signal strength variable address
#define TOF_SIZE_SIGNAL_STRENGTH 2//The number of bytes occupied by the signal strength variable

#define TOF_ADDR_RANGE_PRECISION 0x2c//Ranging accuracy variable address
#define TOF_SIZE_RANGE_PRECISION 1//The number of bytes occupied by the ranging precision variable

#define IIC_CHANGE_TO_UART_DATA 0x40//Change the communication mode to the byte data that needs to be sent by UART

typedef struct {
	uint8_t id;//ID
	uint8_t interface_mode;//communication interface mode,0-UART，1-CAN，2-I/O，3-IIC
	uint32_t uart_baudrate;//UART baud rate
	uint32_t system_time;//system time
  float dis;//distance unit: m
  uint16_t dis_status;//distance status indication
	uint16_t signal_strength;//signal strength
	uint8_t range_precision;//Ranging accuracy
} tofsense_f_output_parameter;//TOFSense-B Output parameter structure

extern uint8_t iic_read_buff[256];//read buffer array
extern uint8_t iic_write_buff[256];//write cache array
extern uint16_t iic_test_count;
extern uint16_t iic_test_i;
extern tofsense_f_output_parameter tofsense_f_output;//The structure that stores the TOF output data after decoding

void TOF_B_init();
uint8_t IIC_Unpack_Data(uint8_t *pdata,tofsense_f_output_parameter *pdata1);//Read and decode all register information through IIC, and store the decoded variables into the structure member variables
uint8_t IIC_Change_Mode_To_UART();//Change the communication mode to UART mode through IIC
uint8_t IIC_Get_All_Register_Data(uint8_t *pdata);//Read the data of all registers in sequence through IIC and store them in the specified array
uint8_t TOF_IIC_Read_N_Byte(uint8_t Addr,uint8_t num,uint8_t *pdata);//Read N bytes of data at the specified address through IIC and store it in the specified array
uint8_t TOF_IIC_Write_One_Byte(uint8_t Addr,uint8_t data);//Write a single byte of data at a specified address through IIC


#endif
