#include "TOF_B_I2C.h"

int TOF_B_dev;

uint8_t iic_read_buff[256];//read buffer array
uint8_t iic_write_buff[256];//write cache array
uint16_t iic_test_count=0;
uint16_t iic_test_i=0;
tofsense_f_output_parameter tofsense_f_output;//The structure that stores the TOF output data after decoding

/************************************************
function name : IIC_Unpack_Data
function function: Read and decode all register information through IIC, and store the decoded variables into the structure member variables
parameters : *pdata cache array pointer *pdata1 store variable structure pointer
return value : mark Whether to read and decode successfully flag bit, 0 is wrong, 1 is correct
Call method: for example:IIC_Unpack_Data(iic_read_buff,&tofsense_f_output);
*************************************************/
uint8_t IIC_Unpack_Data(uint8_t *pdata,tofsense_f_output_parameter *pdata1)
{
	uint8_t mark=0;//Whether to read and decode the success flag bit

	mark=IIC_Get_All_Register_Data(pdata);
	if(mark == 1)
	{
		pdata1->interface_mode=pdata[TOF_ADDR_MODE]&0x07;
		pdata1->id=pdata[TOF_ADDR_ID];
		pdata1->uart_baudrate=(uint32_t)(((uint32_t)pdata[TOF_ADDR_UART_BAUDRATE])|((uint32_t)pdata[TOF_ADDR_UART_BAUDRATE+1]<<8)|
				                                       ((uint32_t)pdata[TOF_ADDR_UART_BAUDRATE+2]<<16)|((uint32_t)pdata[TOF_ADDR_UART_BAUDRATE+3]<<24));
		pdata1->system_time=(uint32_t)(((uint32_t)pdata[TOF_ADDR_SYSTEM_TIME])|((uint32_t)pdata[TOF_ADDR_SYSTEM_TIME+1]<<8)|
				                                     ((uint32_t)pdata[TOF_ADDR_SYSTEM_TIME+2]<<16)|((uint32_t)pdata[TOF_ADDR_SYSTEM_TIME+3]<<24));
		pdata1->dis=(float)(((uint32_t)pdata[TOF_ADDR_DIS])|((uint32_t)pdata[TOF_ADDR_DIS+1]<<8)|
				                          ((uint32_t)pdata[TOF_ADDR_DIS+2]<<16)|((uint32_t)pdata[TOF_ADDR_DIS+3]<<24))/1000;
		pdata1->dis_status=(uint16_t)(((uint16_t)pdata[TOF_ADDR_DIS_STATUS])|((uint16_t)pdata[TOF_ADDR_DIS_STATUS+1]<<8));
		pdata1->signal_strength=(uint16_t)(((uint16_t)pdata[TOF_ADDR_SIGNAL_STRENGTH])|((uint16_t)pdata[TOF_ADDR_SIGNAL_STRENGTH+1]<<8));
		pdata1->range_precision=pdata[TOF_ADDR_RANGE_PRECISION];
	}

	return mark;//return flag
}


/************************************************
function name : IIC_Change_Mode_To_UART
function function : Change the communication mode to UART mode through IIC
parameters: 
return value : Whether the mark operation is correct or not, 0 is wrong, 1 is correct
*************************************************/
uint8_t IIC_Change_Mode_To_UART()
{
	uint8_t mark=0;//Whether the operation is correct flag bit

	mark=TOF_IIC_Write_One_Byte(TOF_ADDR_MODE,IIC_CHANGE_TO_UART_DATA);

	return mark;//return flag
}

/************************************************
function name : IIC_Get_All_Register_Data
function function : Read the data of all registers in sequence through IIC and store them in the specified array
parameters : *pdata cache array pointer 
return value : Whether the mark operation is correct or not, 0 is wrong, 1 is correct
*************************************************/
uint8_t IIC_Get_All_Register_Data(uint8_t *pdata)
{
	uint8_t mark=0;//Whether the operation is correct flag bit


	mark=TOF_IIC_Read_N_Byte(0x00,TOF_REGISTER_TOTAL_SIZE,pdata);

	return mark;//return flag
}

uint8_t TOF_IIC_Read_N_Byte(uint8_t reg, uint8_t num, uint8_t *buf)
{
    write(TOF_B_dev,&reg,1);
    if(read(TOF_B_dev,buf,num) > 0)
        return 1;
    else
        return 0;
}

uint8_t TOF_IIC_Write_One_Byte(uint8_t reg, uint8_t Value)
{
    uint8_t data[2] = {reg, Value};
    write(TOF_B_dev, data, 2);
    return 1;
}

void TOF_B_init()
{   
    if (wiringPiSetup() < 0) 
        printf("wiring Pi init fail.");
    TOF_B_dev = wiringPiI2CSetup(ADDR_SLAVE);

}

